define([
    'underscore',
    'modules/form/section-view',
    'text!modules/new-appointment-wizard/wizard-section.html',
],
function(_, SectionView, template) {
    'use strict';

    return SectionView.extend({
        tagName: 'div',
        className: 'form-section wizard-step-form-section',
        childViewContainer: '.wizard-step-questions',
        template: template,

        initialize: function(options) {
            this._initializeSection(options);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
            if (options.validator) {
                this.validator = options.validator;
            }
        },
        // _initializeSection: an initialize helper, in which sectionName
        // can be passed in options or as separate argument;
        // initializeQuestionEventListeners() should be called afterwards;
        // when there are dynamic answers for a question item, set its
        // values [], before calling initializeQuestionEventListeners()
        _initializeSection: function(options, sectionName, metadata, legendHead) {
            this.sectionName = _.isUndefined(sectionName) ? options.sectionName : sectionName;
            this.metadata = _.isUndefined(metadata) ? options.metadata : metadata;
            this.legendHead = _.isUndefined(legendHead) ? options.legendHead : legendHead;

            this.collection = this.getQuestionsFromMetadata(this.sectionName, this.metadata);
            if (options.validator) {
                this.validator = options.validator;
            }
        },

        templateContext: function() {
            var jsonSection = this.getLegendFromMetadata(this.sectionName, this.metadata, true);

            return {
                legend: jsonSection.legend, // may contain HTML, template will render

                // may be dynamically
                legendHead: (this.legendHead === undefined) ? jsonSection.legendHead : this.legendHead,
                instructions: jsonSection.instructions,
            };
        },
    });
});
